//
//  Receiving_Local_Notifications_in_the_BackgroundAppDelegate.m
//  Receiving Local Notifications in the Background
//
//  Created by Vandad Nahavandipoor on 20/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Receiving_Local_Notifications_in_the_BackgroundAppDelegate.h"

@implementation Receiving_Local_Notifications_in_the_BackgroundAppDelegate

@synthesize window = _window;

- (BOOL) localNotificationWithMessage:(NSString *)paramMessage
                    actionButtonTitle:(NSString *)paramActionButtonTitle
                          launchImage:(NSString *)paramLaunchImage
                     applicationBadge:(NSInteger)paramApplicationBadge
                       secondsFromNow:(NSTimeInterval)paramSecondsFromNow
                             userInfo:(NSDictionary *)paramUserInfo{
  
  if ([paramMessage length] == 0){
    return NO;
  }
  
  UILocalNotification *notification = [[UILocalNotification alloc] init];
  notification.alertBody = paramMessage;
  notification.alertAction = paramActionButtonTitle;
  
  if ([paramActionButtonTitle length]> 0){
    /* Upewniamy się, że posiadamy przycisk akcji, którego naciśnięcie
      przez użytkownika spowoduje uruchomienie aplikacji. */
    notification.hasAction = YES;
  } else {
    notification.hasAction = NO;
  }
  
  /* W tym miejscu można zmienić obraz wyświetlany podczas uruchamiania aplikacji,
   gdy akcja powiadomienia jest wyświetlana użytkownikowi. */
  notification.alertLaunchImage = paramLaunchImage;
  
  /* Zmiana liczby wyświetlanej na ikonie aplikacji, gdy powiadomienie
   jest prezentowane użytkownikowi. Jeśli nawet użytkownik usunie powiadomienie, 
   liczba wyświetlana na ikonie aplikacji zostanie zmieniona. */
  notification.applicationIconBadgeNumber = paramApplicationBadge;
  
  /* Ten słownik zostanie później przekazany aplikacji,
   jeśli użytkownik zdecyduje się na wyświetlenie powiadomienia. */
  notification.userInfo = paramUserInfo;
  
  /* Konieczne jest pobranie systemowej strefy czasowej, aby komunikat
   zawierał odpowiednią datę, gdy zmianie ulegnie strefa czasowa użytkownika. */
  NSTimeZone *timeZone = [NSTimeZone systemTimeZone];
  notification.timeZone = timeZone;
  
  /* Określenie dostarczenia powiadomienia po upływie x sekund. */
  NSDate *today = [NSDate date];
  
  NSDate *fireDate = [today dateByAddingTimeInterval:paramSecondsFromNow];
  
  NSCalendar *calendar = [NSCalendar autoupdatingCurrentCalendar];
  
  NSUInteger dateComponents = 
  NSYearCalendarUnit |
  NSMonthCalendarUnit |
  NSDayCalendarUnit |
  NSHourCalendarUnit |
  NSMinuteCalendarUnit |
  NSSecondCalendarUnit;
  
  NSDateComponents *components = [calendar components:dateComponents
                                             fromDate:fireDate];
  
  /* W tym miejscu masz szansę zmiany przedstawionych powyżej komponentów.
   Dlatego też komponenty daty zostały najpierw pobrane. */
  fireDate = [calendar dateFromComponents:components];
  
  /* Wreszcie ustawiamy datę uruchomienia powiadomienia. */
  notification.fireDate = fireDate;
  
  [[UIApplication sharedApplication] cancelAllLocalNotifications];
  
  [[UIApplication sharedApplication] scheduleLocalNotification:notification];
  
  return YES;
  
}

- (void)            application:(UIApplication *)application 
    didReceiveLocalNotification:(UILocalNotification *)notification{
  
  NSString *message = @"Powiadomienie lokalne zostało dostarczone.";
  
  [[[UIAlertView alloc] initWithTitle:@"Powiadomienie lokalne"
                              message:message
                             delegate:nil
                    cancelButtonTitle:@"OK"
                    otherButtonTitles:nil, nil] show];
    
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  
  id scheduledLocalNotification = 
  [launchOptions valueForKey:
   UIApplicationLaunchOptionsLocalNotificationKey];
  
  if (scheduledLocalNotification != nil){
    
    /* Powiadomienie lokalne zostało otrzymane, kiedy aplikacja nie była uruchomiona.
      Przeprowadzamy rzutowanie zmiennej ScheduledLocalNotification na UILocalNotification
      i używamy jej w aplikacji. */
    
    NSString *message = @"Pojawiło się powiadomienie lokalne";
    [[[UIAlertView alloc] initWithTitle:@"Powiadomienie"
                                message:message
                               delegate:nil
                      cancelButtonTitle:@"OK"
                      otherButtonTitles:nil, nil] show];
    
  } else {
    
      NSString *message =@"Dostępna jest nowa wiadomość. Czy chcesz ją teraz przeczytać?";
    
    /* Jeżeli powiadomienie lokalne nie uruchomiło aplikacji,
      wywołujemy nowe powiadomienie lokalne. */
    
    [self localNotificationWithMessage:message
                     actionButtonTitle:@"Tak"
                           launchImage:nil
                      applicationBadge:1
                        secondsFromNow:10.0f
                              userInfo:nil];
    
    message = @"Nowe powiadomienie lokalne zostanie wyświetlone po upływie 10 sekund.";
    
    [[[UIAlertView alloc] initWithTitle:@"Konfiguracja"
                                message:message
                               delegate:nil
                      cancelButtonTitle:@"OK"
                      otherButtonTitles:nil, nil] show];
    
  }
  
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
